using System;

class Program
{
    static void Main()
    {
        int T = int.Parse(Console.ReadLine());
        for (int t = 0; t < T; t++)
        {
            int N = int.Parse(Console.ReadLine());
            int[] row1 = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
            int[] row2 = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

            int result = MaxHappiness(N, row1, row2);
            Console.WriteLine(result);
        }
    }

    static int MaxHappiness(int N, int[] row1, int[] row2)
    {
        // Calculate happiness without any swaps
        int happiness = CalculateHappiness(row1, row2, N);
        int maxHappiness = happiness;

        // Try swapping each column
        for (int j = 0; j < N; j++)
        {
            // Swap values in column j
            int temp = row1[j];
            row1[j] = row2[j];
            row2[j] = temp;

            // Calculate happiness after the swap
            int happinessAfterSwap = CalculateHappiness(row1, row2, N);
            maxHappiness = Math.Max(maxHappiness, happinessAfterSwap);

            // Swap back
            row2[j] = row1[j];
            row1[j] = temp;
        }

        return maxHappiness;
    }

    static int CalculateHappiness(int[] row1, int[] row2, int N)
    {
        int happiness = 0;
        int previousValue = row1[0];

        for (int j = 0; j < N; j++)
        {
            // Check row1[j]
            if (j > 0 && (row1[j] % 2 == previousValue % 2))
            {
                happiness++;
            }
            previousValue = row1[j];

            // Check row2[j]
            if (j < N && (row2[j] % 2 == previousValue % 2))
            {
                happiness++;
            }
            previousValue = row2[j];
        }

        return happiness;
    }
}